// XISLExchangeTag.cpp: CXISLExchangeTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLExchangeTag.h"
#include "XISLInputTag.h"
#include "XISLCombInputTag.h"
#include "XISLOutputTag.h"
#include "XISLCombOutputTag.h."

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLExchangeTag::CXISLExchangeTag(CXISLTag *pParent,int nComb,LPCTSTR lpszURI)
{
	m_pParentTag = pParent;

	m_nBmpID = IDB_EXCHANGE;
	m_nTagType = ID_TAG_EXCHANGE;

	ASSERT(pParent->m_nTagType == ID_TAG_DIALOG
		|| pParent->m_nTagType == ID_TAG_PEXCHANGE
		|| pParent->m_nTagType == ID_TAG_AEXCHANGE
		|| pParent->m_nTagType == ID_TAG_SEXCHANGE);

	m_pXISLAct = new CXISLActTag((CXISLTag*)this);
	m_pXISLOpr = new CXISLOprTag((CXISLTag*)this,nComb,lpszURI);
	m_pLocalVar = new CXISLVarList(this);
}


CXISLExchangeTag::CXISLExchangeTag(const CXISLExchangeTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_pXISLAct = cpXISL.m_pXISLAct;
	m_pXISLOpr = cpXISL.m_pXISLOpr;
	m_pLocalVar = cpXISL.m_pLocalVar;
}

CXISLExchangeTag::~CXISLExchangeTag()
{
	delete m_pXISLAct;
	m_pXISLAct = NULL;

	delete m_pXISLOpr;
	m_pXISLOpr = NULL;

	delete m_pLocalVar;
	m_pLocalVar = NULL;
}

CXISLExchangeTag& CXISLExchangeTag::operator=(const CXISLExchangeTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_pXISLAct = cpXISL.m_pXISLAct;
		m_pXISLOpr = cpXISL.m_pXISLOpr;
		m_pLocalVar = cpXISL.m_pLocalVar;
	}
	return *this;
}


//CSize CXISLExchangeTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
//@\@Fexchange̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLExchangeTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	int nViewSizeX,nViewSizeY;

	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
		
	CBitmap FlowBMP;
	BITMAP bmp;

	FlowBMP.LoadBitmap(m_nBmpID);

	FlowBMP.GetBitmap(&bmp);
	CBitmap *pOldBMP = MemDC.SelectObject(&FlowBMP);

	pDC->BitBlt(nX,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
	FlowBMP.DeleteObject();
	SetRectBMP(nX,nY,bmp.bmWidth,bmp.bmHeight);

	nX += bmp.bmWidth/2;
	nY += bmp.bmHeight-1;

	pDC->MoveTo(nX,nY);
	POINT point[3];
	point[0].x = nX;
	nY += 20;
	point[0].y = nY;
	nX += bmp.bmWidth;
	point[1].x = nX+5;
	point[1].y = nY;
	point[2].x = nX;
	nY += 35;
	point[2].y = nY;

	int nBX = nX;
	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,0));
	pOldPen = pDC->SelectObject(&linePen);

	pDC->PolyBezierTo(point,3);
	int nMaxX = nX;
/*	int pY = nY;
	int pX = nX;*/
	if(m_XISLPromptList.IsEmpty()==0){
		POSITION pos;
		CXISLPrompt *pPromptTag;
		for(int i=0;i<m_XISLPromptList.GetCount();i++){
			pos = m_XISLPromptList.FindIndex(i);
			pPromptTag = (CXISLPrompt *)m_XISLPromptList.GetAt(pos);
			FlowBMP.LoadBitmap(pPromptTag->m_nBmpID);
			
			FlowBMP.GetBitmap(&bmp);
			if(i==0)
			{
				pOldBMP = MemDC.SelectObject(&FlowBMP);
				pDC->MoveTo(nMaxX,nY);
				nY += 10;
				pDC->LineTo(nMaxX,nY);
			}
			else
				MemDC.SelectObject(&FlowBMP);

			pDC->MoveTo(nMaxX,nY);
			nY += 20;
			pDC->LineTo(nMaxX,nY);

			pDC->BitBlt(nMaxX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
			FlowBMP.DeleteObject();
			pPromptTag->SetRectBMP(nMaxX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight);
			nY+=bmp.bmHeight;
/*			if(pPromptTag->m_pXISLAct->m_ActionList.IsEmpty()==0){
				pX+=40;
				pPromptTag->m_pXISLAct->DrawXISLFlow(pDC,pX,pY);
			}*/
		}
//		pY=nY;
	}
	if(m_pXISLOpr)
	{
		CSize sizeOpr = m_pXISLOpr->DrawXISLFlow(pDC,nX,nY);
		nMaxX = sizeOpr.cx;
		nY = sizeOpr.cy;
	}

	if(m_pXISLAct)
	{
		CSize sizeAct = m_pXISLAct->DrawXISLFlow(pDC,nX,nY);
		if(nMaxX < sizeAct.cx)
			nMaxX = sizeAct.cx;
		nY = sizeAct.cy;
	}

	if(m_pXISLAct->m_ActionList.GetCount() == 0
		|| m_pXISLOpr->m_InputList.GetCount() == 0)
	{
		pDC->MoveTo(nBX+4,nY-6);
		pDC->LineTo(nBX,nY);
		pDC->MoveTo(nBX-4,nY-6);
		pDC->LineTo(nBX,nY);
	}
	nViewSizeX = nMaxX;
	nViewSizeY = nY;
	MemDC.SelectObject(pOldBMP);
	FlowBMP.DeleteObject();
	MemDC.DeleteDC();

	return CSize(nViewSizeX+100,nViewSizeY+100);
}

//CXISLTag* CXISLExchangeTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLExchangeTag::FindTag(POINT point,BOOL bOnly)
{
	m_rectBMP.NormalizeRect();
	if(m_rectBMP.PtInRect(point))
		return (CXISLTag*)this;
	else if(!bOnly)
	{
		CXISLTag* pTag;
		CXISLPrompt *pPromptTag;
		POSITION pos;
		pos = m_XISLPromptList.GetHeadPosition();
		if(m_XISLPromptList.IsEmpty()==0){
			for(int i=0;i<m_XISLPromptList.GetCount();i++){
				pPromptTag = (CXISLPrompt*)m_XISLPromptList.GetNext(pos);
				pTag = pPromptTag->FindTag(point,TRUE);
				if(pTag)
					return pTag;
			}
		}
		if(m_pXISLOpr)
		{
			pTag = m_pXISLOpr->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
		if(m_pXISLAct)
		{
			pTag = m_pXISLAct->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
	}

	return NULL;
}

LPCTSTR CXISLExchangeTag::GetOprTarget()
{
	if(m_pXISLOpr)
		return m_pXISLOpr->GetTarget();
	else
		return "";
}

void CXISLExchangeTag::SetOprTarget(LPCTSTR lpszTarget)
{
	if(m_pXISLOpr)
		m_pXISLOpr->SetTarget(lpszTarget);
}

//LPCTSTR CXISLDialogTag::GetXISLString()
//@\@FexchangeȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLExchangeTag::GetXISLString()
{
	m_strXISL = "<exchange>\r\n";
	CString strTemp;
	m_pLocalVar->GetXISLString(strTemp);
	if(m_pLocalVar)
		m_strXISL += strTemp;
	if(m_XISLPromptList.IsEmpty()==0){
		CXISLPrompt *pPromptTag;
		POSITION pos = m_XISLPromptList.GetHeadPosition();
		for(int i=0;i<m_XISLPromptList.GetCount();i++){
			pPromptTag = (CXISLPrompt *)m_XISLPromptList.GetNext(pos);
			m_strXISL += pPromptTag->GetXISLString();
		}
	}
	if(m_pXISLOpr)
		m_strXISL += m_pXISLOpr->GetXISLString();
	if(m_pXISLAct)
		m_strXISL += m_pXISLAct->GetXISLString();

	m_strXISL += "</exchange>\r\n";
	return m_strXISL;
}

//int CXISLExchangeTag::GetItemCount()
//@\@FexchangeȉXISL̃c[ڐԂ
//@F
//߂lFintCc[ڐ
int CXISLExchangeTag::GetItemCount()
{
	int nCount = 0;
	if(m_XISLPromptList.IsEmpty()==0){
		CXISLPrompt *pPromptTag;
		POSITION pos = m_XISLPromptList.GetHeadPosition();
		for(int i=0;i<m_XISLPromptList.GetCount();i++){
			pPromptTag = (CXISLPrompt *)m_XISLPromptList.GetNext(pos);
			nCount += pPromptTag->GetItemCount();
		}
	}
	if(m_pXISLAct)
		nCount += m_pXISLAct->GetItemCount();
	if(m_pXISLOpr)
		nCount += m_pXISLOpr->GetItemCount();
	nCount++; //<exchange>̕
	return nCount;
}


//BOOL CXISLExchangeTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLExchangeTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_EXCHANGE];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	if(m_XISLPromptList.IsEmpty()==0){
		POSITION pos;
		for(int i=0;i<m_XISLPromptList.GetCount();i++){
			pos=m_XISLPromptList.FindIndex(i);
			CXISLPrompt *pPromptTag = (CXISLPrompt *)m_XISLPromptList.GetAt(pos);
			pPromptTag->RegistXISLTree(pTree,hParent);
		}
	}
	if(m_pXISLOpr)
		m_pXISLOpr->RegistXISLTree(pTree,hParent);
	if(m_pXISLAct)
		m_pXISLAct->RegistXISLTree(pTree,hParent);
		
	return TRUE;
}

/*
//CXISLActTag* CXISLExchangeTag::CreateActionTag()
//@\@FAction𐶐
//@F
//ԂlFIuWFNg̃|C^Cɐς݂ȂNULL
CXISLActTag* CXISLExchangeTag::CreateActionTag()
{
	if(m_pXISLAct)
		return NULL;
	
	m_pXISLAct = new CXISLActTag((CXISLTag*)this);

	return m_pXISLAct;
}


//CXISLOprTag* CXISLExchangeTag::CreateOprTag()
//@\@FOperation𐶐
//@F
//ԂlFIuWFNg̃|C^Cɐς݂ȂNULL
CXISLOprTag* CXISLExchangeTag::CreateOprTag()
{
	if(m_pXISLOpr)
		return NULL;

	m_pXISLOpr = new CXISLOprTag((CXISLTag*)this);

	return m_pXISLOpr;
}
*/
/*
//CXISLInputTag* CXISLExchangeTag::InsertInput(int nType,LPCTSTR lpszEvent,
//											 LPCTSTR lpszMatch,LPCTSTR lpszNameList)
//@\@F<input>쐬
//@Fint nType			:̓_eB̃^Cv
//		  LPCTSTR lpszEvent :̓Cxg
//		  LPCTSTR lpszMatch :}b`
//		  LPCTSTR lpszNameList:namelist
//ԂlFCXISLInputTag*@sFNULL
CXISLInputTag* CXISLExchangeTag::InsertInput(int nType,LPCTSTR lpszEvent,
											 LPCTSTR lpszMatch,LPCTSTR lpszNameList)
{
	if(m_pXISLOpr)
		return m_pXISLOpr->CreateInput(nType,lpszEvent,lpszMatch,lpszNameList);

	return NULL;
}
*/
/*
CXISLOutputBrowser* CXISLExchangeTag::InsertOutputBrowser(int nType,int nEvent,LPCTSTR lpszWName,
														  LPCTSTR lpszParam,int nParam)
{
	if(m_pXISLAct)
		return m_pXISLAct->CreateOutputBrowser(nType,nEvent,lpszWName,lpszParam,nParam);

	return NULL;
}
*/
/*
CXISLCallTag* CXISLExchangeTag::InsertCall(CXISLDialogTag *pCallDialog,LPCTSTR lpszNameList,LPCTSTR lpszReturnList)
{
	ASSERT(m_pXISLAct);

	return m_pXISLAct->CreateCall(pCallDialog,lpszNameList,lpszReturnList);
}
*/

//SẴIy[V폜
//2003/5/19 
void CXISLExchangeTag::DeleteAllOpr()
{
	CXISLTag *pTag;
	while(m_pXISLOpr->m_InputList.IsEmpty() == FALSE){
		pTag = (CXISLTag*)(m_pXISLOpr->m_InputList.GetHead());
		if(pTag->m_nTagType == ID_TAG_INPUT){
			m_pXISLOpr->DeleteOprItem((CXISLOprItem *)pTag);
		}
		else if(pTag->m_nTagType == ID_TAG_SINPUT || pTag->m_nTagType == ID_TAG_PINPUT || pTag->m_nTagType == ID_TAG_AINPUT){
			CXISLCombInputTag *pCITag = (CXISLCombInputTag *)(m_pXISLOpr->m_InputList.GetHead());
			pCITag->DeleteCombInputList();
			m_pXISLOpr->DeleteOprItem(pCITag);
		}

	}
}

//SẴANV폜
//2003/5/19@
void CXISLExchangeTag::DeleteAllAct()
{
	CXISLTag *pTag;
	while(m_pXISLAct->m_ActionList.IsEmpty() == 0){
		pTag = (CXISLTag*)(m_pXISLAct->m_ActionList.GetHead());
		if(pTag->m_nTagType == ID_TAG_OUTPUT || pTag->m_nTagType == ID_TAG_RETURN || pTag->m_nTagType == ID_TAG_ASSIGN
			|| pTag->m_nTagType == ID_TAG_CALL || pTag->m_nTagType == ID_TAG_GOTO){
			m_pXISLAct->DeleteActItem((CXISLActItem *)pTag);
		}
		//Ǐo̓^O
		/*else if(pTag->m_nTagType == ID_TAG_SOUTPUT || pTag->m_nTagType == ID_TAG_POUTPUT || pTag->m_nTagType == ID_TAG_AOUTPUT){
			//
		}*/
		//Switch^O
		else if(pTag->m_nTagType == ID_TAG_SWITCH){
			CXISLSwitchTag *pSTag = (CXISLSwitchTag *)(m_pXISLAct->m_ActionList.GetHead());
			pSTag->DeleteItemIntoCase();
			m_pXISLAct->DeleteActItem(pSTag);
		}
		//EXIT^O
		else if(pTag->m_nTagType == ID_TAG_EXIT){
			m_pXISLAct->SetExit(FALSE);
		}
	}
}

//vvg^OvvgXgɒǉ
//2003/6/5@
void CXISLExchangeTag::InsertPrompt(CXISLPrompt *pPromptTag)
{
	m_XISLPromptList.AddTail(pPromptTag);
}

//vvg^O폜(w肳ꂽ̂̂)
//2003/6/6@
BOOL CXISLExchangeTag::DeletePrompt(CXISLPrompt *pPromptTag)
{
	CString str;
	POSITION pos =m_XISLPromptList.Find(pPromptTag);
	if(pos==NULL)return FALSE;
	pPromptTag->DeleteAllAct();//Prompt^Õ^O폜
	POSITION posdel = pos;
	m_XISLPromptList.RemoveAt(posdel);
	delete pPromptTag;
	pPromptTag=NULL;
	for(int i=0;i<m_XISLPromptList.GetCount();i++){
		//JEgԍ̐
		str.Format("%d",i+1);
		pos =m_XISLPromptList.FindIndex(i);
		pPromptTag = (CXISLPrompt*)(m_XISLPromptList.GetAt(pos));
		//JEgԍ̍Đݒ
		pPromptTag->SetCont(str);
	}
	return TRUE;
}

//vvg^O폜(S)
//2003/6/6@
void CXISLExchangeTag::DeletePromptList()
{
	CXISLPrompt *pPromptTag;
	while(m_XISLPromptList.IsEmpty()==0){
		//擪Prompt폜
		pPromptTag = (CXISLPrompt*)(m_XISLPromptList.GetHead());
		pPromptTag->DeleteAllAct();//Prompt^Õ^O폜
		m_XISLPromptList.RemoveHead();
		delete pPromptTag;
		pPromptTag=NULL;
	}
}
